<!-- app/Views/emails/transaction_paid.php -->
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Payment Successful</title>
</head>
<body style="font-family: sans-serif; color: #333;">
    <div style="max-width: 600px; margin: auto; padding: 20px; border: 1px solid #ddd; border-radius: 5px;">
        <h2 style="color: #16a34a;">Payment Successful!</h2>
        <p>Hello <?= esc($user->name) ?>,</p>
        <p>We have successfully received your payment for the following transaction. Your registration is complete!</p>
        
        <hr style="border: none; border-top: 1px solid #eee; margin: 20px 0;">
        <p><strong>Invoice Number:</strong> <?= esc($transaction->invoice_number) ?></p>
        <p><strong>Transaction Date:</strong> <?= date('d M Y, H:i', strtotime($transaction->created_at)) ?></p>
        <p><strong>Total Amount:</strong> Rp <?= number_format($transaction->total_amount, 0, ',', '.') ?></p>
        <hr style="border: none; border-top: 1px solid #eee; margin: 20px 0;">

        <h3 style="color: #333;">Your E-Tickets:</h3>
        <div style="padding: 0;">
            <?php foreach($participants as $p): ?>
                <div style="margin-bottom: 20px; border: 1px solid #eee; padding: 15px; border-radius: 5px; text-align: center;">
                    <h4 style="margin-top: 0; margin-bottom: 5px; font-size: 1.1em;"><?= esc($p->name) ?></h4>
                    <p style="margin: 0; color: #777; font-size: 0.9em;"><?= esc($p->email) ?> / <?= esc($p->phone_number) ?></p>
                    
                    <?php if (!empty($p->qr_image_path)): ?>
                        <!-- PERUBAHAN UTAMA DI SINI -->
                        <!-- Tampilkan gambar QR menggunakan CID -->
                        <div style="margin: 15px 0;">
                            <img src="cid:<?= esc($p->qr_number) ?>" alt="QR Code Ticket" style="display: block; margin: auto; max-width: 200px;">
                        </div>
                        <p style="font-size: 1.2em; letter-spacing: 2px; font-family: monospace; color: #4f46e5; margin-bottom: 0;">
                            <?= esc($p->qr_number) ?>
                        </p>
                    <?php else: ?>
                        <p style="color: red; margin: 15px 0;">QR Code could not be generated.</p>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
        
        <p style="text-align: center;">Please show this e-ticket at the event for check-in. See you there!</p>
    </div>
</body>
</html>