<?= $this->extend('frontend/layouts/main') ?>

<?= $this->section('pageTitle') ?><?= lang('Transaction.start_title') ?><?= $this->endSection() ?>

<?= $this->section('mainContent') ?>
<div class="container mx-auto px-4 py-8">
    <div class="max-w-4xl mx-auto">
        <div class="text-center mb-12">
            <h1 class="text-4xl font-bold text-gray-800"><?= lang('Transaction.start_title') ?></h1>
            <p class="text-gray-600 mt-2 text-lg"><?= lang('Transaction.start_subtitle') ?></p>
        </div>

        <?= $this->include('frontend/components/_notifications') ?>

        <?php if (!empty($events)): ?>
            <!-- Grid untuk daftar event -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php foreach ($events as $event): ?>
                    <!-- Kartu Event -->
                    <a href="<?= route_to('transaction.participants.form', $event->slug) ?>" class="group block bg-white rounded-lg shadow-lg overflow-hidden transform hover:-translate-y-2 transition-transform duration-300">
                        <div class="relative">
                            <!-- Gambar Thumbnail -->
                            <img src="<?= $event->thumbnail ?? 'https://via.placeholder.com/400x250/E2E8F0/4A5568?text=No+Image' ?>" alt="<?= esc($event->name) ?>" class="w-full h-48 object-cover">
                            <!-- Overlay -->
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent"></div>
                            <!-- Tanggal Event -->
                            <span class="absolute top-3 right-3 bg-indigo-600 text-white text-xs font-bold px-2 py-1 rounded-full">
                                <?= date('d M Y', strtotime($event->start_date)) ?>
                            </span>
                        </div>

                        <!-- Detail Konten Kartu -->
                        <div class="p-6 flex flex-col">
                            <h3 class="text-xl font-bold text-gray-900 mb-2 truncate group-hover:text-indigo-600 transition-colors duration-300"><?= esc($event->name) ?></h3>
                            <p class="text-gray-600 text-sm line-clamp-3 flex-grow"><?= esc($event->description) ?></p>
                            
                            <div class="mt-4 pt-4 border-t border-gray-200 text-center">
                                <span class="text-indigo-600 font-semibold"><?= lang('Transaction.register_now_button') ?></span>
                            </div>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center bg-yellow-100 text-yellow-800 p-6 rounded-md">
                <p class="font-medium"><?= lang('Transaction.no_active_events') ?></p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>

<style>
    /* Helper untuk memotong teks di beberapa baris (jika Tailwind JIT tidak aktif) */
    .line-clamp-3 {
        display: -webkit-box;
        -webkit-line-clamp: 3;
        -webkit-box-orient: vertical;  
        overflow: hidden;
    }
</style>